/* Rev Jul 11 2013 MS Initial version */
/* Rev Sep 11 2013 SM Added mode verfication after mode transition,  */
/*                    added comments and deleted unused functions */
/* Rev Oct 08 2013 SM Re-organized code and minor code changes */
/* Rev Nov 13 2013 SM Replaced "while" with "if" clause in mode verification */
/* Rev Jan 29 2015 SM Removed code: writes to SC_DC3, SC_DC4 (caused IVOR1)  */
/*                    & changed PLLCAL3, init order of PREDIV, MFD, RFDPHI */

#include "project.h"

void PLL_160MHz(void)
{
	  /* Connect XOSC to PLL. We ultimately use the output of PLL1. PLL1 must be fed the output of PLL0 */
	  CGM.AC3_SC.B.SELCTL = 1; //40 MHz XOSC selected as input of PLL0

	  CGM.AC4_SC.B.SELCTL = 0; //PLL0_PHI1 selected as input of PHI1

	  /* Configure PLL0 Dividers - 160MHz from 40Mhx XOSC */
	  /* PLL input = FXOSC = 40MHz
	     VCO range = 600-1250MHz
	  */

	  /* Configure PLL0 to 160 MHz.
	   * f_PLL0_PHI0 = fin * (MFD/(PREDIV*RFDPHI))
	   * 	  		 = 40 * (12/(2*1))
	   * 	  		 = 40 * 6
	   * 	  		 = 240 MHz
	   *
	   * f_PLL0_PHI1 = fin * (MFD/(PREDIV*RFDPHI1))
	   * 			 = 40 * (12/(2*6))
	   * 			 = 40 MHz
	   */
	  PLLDIG.PLL0DV.B.RFDPHI1 = 6;
	  PLLDIG.PLL0DV.B.RFDPHI = 1;
	  PLLDIG.PLL0DV.B.PREDIV  = 2;
	  PLLDIG.PLL0DV.B.MFD     = 12;

	  /* Program PLL1 to same frequency as PLL0.
	   * MFD multiplies input by at least 10. So multiply by 10 and RFD = 5.
	   * PLL1_PHI = freq_ref * (MFD/(2 * RFD)) =
	   * 		  = 40 * (16/(2*2))
	   * 		  = 40 * 4
	   * 		  = 160 MHz
	   */
	  PLLDIG.PLL1DV.B.RFDPHI = 2;
	  PLLDIG.PLL1DV.B.MFD = 16;

	  /* switch to PLL1 */
	  MC_ME.DRUN_MC.R = 0x001300F4;
	  MC_ME.MCTL.R = 0x30005AF0;
	  MC_ME.MCTL.R = 0x3000A50F;
	  while(MC_ME.GS.B.S_MTRANS == 1);      /* Wait for mode transition complete */
}

void system160mhz(void)
{
	/* SYS_CLK */
  CGM.SC_DC0.B.DIV = 3;  /* Freq = sysclk / (0+1) = sysclk */
  CGM.SC_DC0.B.DE  = 1;  /* Enable divided clock */

  PLL_160MHz();

  /* Configure CLKOUT0 */
//  MCB.CLKOUT_SEL.B.CLKOUT0 = 0b0010; //CLKOUT source is PLL0_PHI_CLK
  MCB.CLKOUT_SEL.B.CLKOUT0 = 0b0100; //CLKOUT source is PLL1_PHI_CLK
  CGM.AC14_DC0.R = 0x80090000; //CLKOUT0 is divided by 10 and enabled
  SIUL2.MSCR[22].B.OBE = 1;
  SIUL2.MSCR[22].B.SSS = 1;
}

void enter_STOP_mode (void) {
  MC_ME.MCTL.R = 0xA0005AF0;      /* Enter STOP mode and key */
  MC_ME.MCTL.R = 0xA000A50F;      /* Enter STOP mode and inverted key */
  while (MC_ME.GS.B.S_MTRANS) {}  /* Wait for STOP mode transition to complete */
}
